/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.ui.asistentes.paginas.ventas;

import ec.gob.sri.dimm.api.colecciones.ElementoNombreValor;
import ec.gob.sri.dimm.api.modelo.ModeloValores;
import ec.gob.sri.dimm.api.modelo.ObjetoModelo;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionValidable;
import ec.gob.sri.dimm.api.modelo.validacion.ListenerValidacionModeloPaginaAsistente;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.api.ui.VistaModelo;
import ec.gob.sri.dimm.api.ui.asistentes.PaginaAsistente;
import ec.gob.sri.dimm.api.ui.util.controles.AyudanteViewer;
import ec.gob.sri.dimm.api.ui.util.eventos.AyudanteSelectionChangedEvent;
import ec.gob.sri.dimm.ats.modelo.obj.Periodo;
import ec.gob.sri.dimm.ats.modelo.obj.asistente.valores.ModeloValoresCompVenta;
import ec.gob.sri.dimm.ats.modelo.obj.ventas.Compensacion;
import ec.gob.sri.dimm.ats.modelo.obj.ventas.ComprobanteVenta;
import ec.gob.sri.dimm.ats.modelo.obj.ventas.Venta;
import ec.gob.sri.dimm.ats.ui.componente.CompensacionComposite;
import ec.gob.sri.dimm.ats.ui.componente.OperacionCompositeCompensaciones;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wb.swt.SWTResourceManager;

public class PaginaComprobanteVenta
extends PaginaAsistente
implements VistaModelo<ComprobanteVenta> {
    private static final String EMISION_FISICA = "F";
    private static final String EMISION_ELECTRONICA = "E";
    private ComprobanteVenta modeloDatos;
    private ModeloValoresCompVenta modeloValores;
    private ListenerValidacionModeloPaginaAsistente listenerValidacionModeloPaginaAsistente;
    private final Periodo periodo;
    private List<AbstractMap.SimpleEntry<String, String>> comprobantesExistentes = new ArrayList<AbstractMap.SimpleEntry<String, String>>();
    private AbstractMap.SimpleEntry<String, String> comprobanteActual = new AbstractMap.SimpleEntry<String, String>("", "");
    private final boolean editando;
    private ComboViewer cvTipoComprobante;
    private Label lblMontoIce;
    private Text txtIvaCero;
    private Text txtIvaNoCero;
    private Text txtMontoIva;
    private Text txtMontoIce;
    private Text txtNoIva;
    private Text txtNumComprobantes;
    private Text txtRetenidoIva;
    private Text txtRetenidoRenta;
    private Label lblSonComprobantesElectrnicos;
    private Button btnSonComprobantesElectronicos;
    private Label lblMontoDeIva;
    private Label lblMontos;
    private Composite container_1;
    private CompensacionComposite compositeCompensaciones;

    public PaginaComprobanteVenta(boolean editando, Periodo periodo, List<AbstractMap.SimpleEntry<String, String>> comprobantesExistentes) {
        super(PaginaComprobanteVenta.class.getName(), "Detalle Comprobante Venta", "Especifique la informaci\u00f3n correspondiente");
        this.setDescription("Especifique la informaci\u00f3n correspondiente al comprobante");
        this.setTitle("Comprobante de Venta");
        this.comprobantesExistentes = comprobantesExistentes;
        this.periodo = periodo;
        this.editando = editando;
    }

    public void setModeloDatos(ComprobanteVenta modeloDatos) {
        this.modeloDatos = modeloDatos;
        if (this.editando) {
            this.comprobanteActual = new AbstractMap.SimpleEntry<String, String>(modeloDatos.getTipoComprobante(), modeloDatos.getTipoEmision());
        }
    }

    public void inicializarModeloValores() {
        this.modeloValores = new ModeloValoresCompVenta(this.periodo);
        this.modeloValores.inicializar();
        this.modeloValores.cargarTiposDeComprobantes(((Venta)this.modeloDatos.getPropietario()).getComprador().getTipoIdentificacion());
    }

    public void procesarModeloDatos() {
        this.seleccionarTipoDeComprobanteEnElCombo();
        this.seleccionarTipoDeEmision();
        this.validarDuplicados();
    }

    private void seleccionarTipoDeComprobanteEnElCombo() {
        String codigoTipoComprobante = this.modeloDatos.getTipoComprobante();
        ElementoNombreValor tipoComprobante = this.modeloValores.obtenerTipoComprobante(codigoTipoComprobante);
        AyudanteViewer.seleccionarElemento((Viewer)this.cvTipoComprobante, (Object)tipoComprobante);
    }

    private void seleccionarTipoDeEmision() {
        boolean esEmisionElectronica = EMISION_ELECTRONICA.equals(this.modeloDatos.getTipoEmision());
        this.btnSonComprobantesElectronicos.setSelection(esEmisionElectronica);
    }

    private void validarDuplicados() {
        this.listenerValidacionModeloPaginaAsistente = new ListenerValidacionModeloPaginaAsistente((InformacionValidable)this.modeloDatos, this){

            protected void ejecutarValidacionFinal(ResultadoValidacion resultado) {
                boolean noSeEstaEditandoElComprobante;
                String codigoTipoComprobante = PaginaComprobanteVenta.this.modeloDatos.getTipoComprobante();
                String tipoEmision = PaginaComprobanteVenta.this.modeloDatos.getTipoEmision();
                AbstractMap.SimpleEntry<String, String> comprobanteSeleccionado = new AbstractMap.SimpleEntry<String, String>(codigoTipoComprobante, tipoEmision);
                boolean bl = noSeEstaEditandoElComprobante = !PaginaComprobanteVenta.this.comprobanteActual.equals(comprobanteSeleccionado);
                if (noSeEstaEditandoElComprobante && PaginaComprobanteVenta.this.comprobantesExistentes.contains(comprobanteSeleccionado)) {
                    resultado.fallarValidacion("El comprobante de venta ya se encuentra registrado para el cliente seleccionado");
                }
            }
        };
        this.modeloDatos.addPropertyChangeListener((PropertyChangeListener)this.listenerValidacionModeloPaginaAsistente);
    }

    private void seleccionTipoEmisionClick() {
        this.btnSonComprobantesElectronicos.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PaginaComprobanteVenta.this.btnSonComprobantesElectronicos.getSelection()) {
                    PaginaComprobanteVenta.this.modeloDatos.setTipoEmision((String)PaginaComprobanteVenta.this.modeloValores.getTiposDeEmisionDeComprobantes().get(PaginaComprobanteVenta.EMISION_ELECTRONICA));
                } else {
                    PaginaComprobanteVenta.this.modeloDatos.setTipoEmision((String)PaginaComprobanteVenta.this.modeloValores.getTiposDeEmisionDeComprobantes().get(PaginaComprobanteVenta.EMISION_FISICA));
                }
            }
        });
    }

    public void createControl(Composite parent) {
        this.container_1 = new Composite(parent, 0);
        this.container_1.setLayout((Layout)new GridLayout(2, false));
        this.container_1.setLayoutData((Object)new GridData(1808));
        this.setControl((Control)this.container_1);
        Label lblTipoDeComprobante = new Label(this.container_1, 0);
        GridData gd_lblTipoDeComprobante = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblTipoDeComprobante.widthHint = 125;
        lblTipoDeComprobante.setLayoutData((Object)gd_lblTipoDeComprobante);
        lblTipoDeComprobante.setText("Tipo de Comprobante");
        this.cvTipoComprobante = new ComboViewer(this.container_1, 8);
        this.cvTipoComprobante.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ElementoNombreValor tipoComprobante = (ElementoNombreValor)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)event);
                if (tipoComprobante != null) {
                    PaginaComprobanteVenta.this.modeloDatos.setTipoComprobante((String)tipoComprobante.getValor());
                    PaginaComprobanteVenta.this.modeloDatos.setDescripcionTipoComprobante(tipoComprobante.getNombre());
                }
            }
        });
        GridData gd_combo = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_combo.widthHint = 200;
        this.cvTipoComprobante.getCombo().setLayoutData((Object)gd_combo);
        Label lblNewLabel = new Label(this.container_1, 0);
        GridData gd_lblNewLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblNewLabel.widthHint = 150;
        lblNewLabel.setLayoutData((Object)gd_lblNewLabel);
        lblNewLabel.setText("N\u00b0 Comprobantes emitidos");
        this.txtNumComprobantes = new Text(this.container_1, 2048);
        this.txtNumComprobantes.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                PaginaComprobanteVenta.this.txtNumComprobantes.selectAll();
            }
        });
        this.txtNumComprobantes.setTextLimit(12);
        GridData gd_txtNumComprobantes = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_txtNumComprobantes.widthHint = 75;
        this.txtNumComprobantes.setLayoutData((Object)gd_txtNumComprobantes);
        this.lblSonComprobantesElectrnicos = new Label(this.container_1, 0);
        this.lblSonComprobantesElectrnicos.setText("\u00bfSon comprobantes electr\u00f3nicos?");
        this.btnSonComprobantesElectronicos = new Button(this.container_1, 32);
        GridData gd_btnSonComprobantesElectronicos = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btnSonComprobantesElectronicos.horizontalIndent = 5;
        this.btnSonComprobantesElectronicos.setLayoutData((Object)gd_btnSonComprobantesElectronicos);
        this.seleccionTipoEmisionClick();
        Label lblBasesImponibles = new Label(this.container_1, 0);
        GridData gd_lblBasesImponibles = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblBasesImponibles.verticalIndent = 10;
        lblBasesImponibles.setLayoutData((Object)gd_lblBasesImponibles);
        lblBasesImponibles.setFont(SWTResourceManager.getBoldFont((Font)lblBasesImponibles.getFont()));
        lblBasesImponibles.setText("Bases Imponibles");
        new Label(this.container_1, 0);
        Composite composite = new Composite(this.container_1, 0);
        GridLayout gl_composite = new GridLayout(4, false);
        gl_composite.marginWidth = 0;
        composite.setLayout((Layout)gl_composite);
        composite.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        Label lblTarifaIva = new Label(composite, 0);
        lblTarifaIva.setText("Tarifa IVA 0%");
        this.txtIvaCero = new Text(composite, 2048);
        this.txtIvaCero.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                PaginaComprobanteVenta.this.txtIvaCero.selectAll();
            }
        });
        this.txtIvaCero.setTextLimit(15);
        GridData gd_txtIvaCero = new GridData(16384, 128, false, false, 1, 1);
        gd_txtIvaCero.widthHint = 100;
        this.txtIvaCero.setLayoutData((Object)gd_txtIvaCero);
        this.txtIvaCero.setBounds(0, 0, 76, 21);
        new Label(composite, 0);
        new Label(composite, 0);
        Label lblTarifaIvaDiferente = new Label(composite, 0);
        GridData gd_lblTarifaIvaDiferente = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblTarifaIvaDiferente.widthHint = 180;
        lblTarifaIvaDiferente.setLayoutData((Object)gd_lblTarifaIvaDiferente);
        lblTarifaIvaDiferente.setText("Tarifa IVA diferente 0%");
        this.txtIvaNoCero = new Text(composite, 2048);
        this.txtIvaNoCero.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                PaginaComprobanteVenta.this.modeloDatos.setModificaIva(false);
            }
        });
        this.txtIvaNoCero.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                PaginaComprobanteVenta.this.txtIvaNoCero.selectAll();
            }
        });
        this.txtIvaNoCero.setTextLimit(15);
        this.txtIvaNoCero.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        new Label(composite, 0);
        new Label(composite, 0);
        Label lblNoObjetoDe = new Label(composite, 0);
        GridData gd_lblNoObjetoDe = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblNoObjetoDe.widthHint = 130;
        lblNoObjetoDe.setLayoutData((Object)gd_lblNoObjetoDe);
        lblNoObjetoDe.setText("No objeto de IVA");
        this.txtNoIva = new Text(composite, 2048);
        this.txtNoIva.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                PaginaComprobanteVenta.this.txtNoIva.selectAll();
            }
        });
        this.txtNoIva.setTextLimit(15);
        this.txtNoIva.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        new Label(composite, 0);
        new Label(composite, 0);
        this.lblMontos = new Label(composite, 0);
        GridData gd_lblMontos = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblMontos.verticalIndent = 10;
        this.lblMontos.setLayoutData((Object)gd_lblMontos);
        this.lblMontos.setFont(SWTResourceManager.getFont((String)".SF NS Text", (int)11, (int)1));
        this.lblMontos.setText("Montos");
        new Label(composite, 0);
        new Label(composite, 0);
        new Label(composite, 0);
        this.lblMontoDeIva = new Label(composite, 0);
        this.lblMontoDeIva.setText("Monto de IVA");
        this.txtMontoIva = new Text(composite, 2048);
        this.txtMontoIva.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                PaginaComprobanteVenta.this.txtMontoIva.selectAll();
            }
        });
        this.txtMontoIva.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                PaginaComprobanteVenta.this.modeloDatos.setModificaIva(true);
            }
        });
        this.txtMontoIva.setTextLimit(15);
        GridData gd_txtMontoIva = new GridData(4, 128, true, false, 1, 1);
        gd_txtMontoIva.widthHint = 100;
        this.txtMontoIva.setLayoutData((Object)gd_txtMontoIva);
        this.lblMontoIce = new Label(composite, 0);
        this.lblMontoIce.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.lblMontoIce.setText("Monto de ICE");
        this.txtMontoIce = new Text(composite, 2048);
        this.txtMontoIce.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                PaginaComprobanteVenta.this.txtMontoIce.selectAll();
            }
        });
        this.txtMontoIce.setTextLimit(15);
        GridData gd_txtMontoIce = new GridData(4, 128, true, false, 1, 1);
        gd_txtMontoIce.widthHint = 100;
        this.txtMontoIce.setLayoutData((Object)gd_txtMontoIce);
        this.crearCompositeCompensaciones();
        Label lblValores = new Label(this.container_1, 0);
        lblValores.setFont(SWTResourceManager.getBoldFont((Font)lblBasesImponibles.getFont()));
        GridData gd_lblValores = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblValores.verticalIndent = 10;
        lblValores.setLayoutData((Object)gd_lblValores);
        lblValores.setText("Valores que le han retenido");
        new Label(this.container_1, 0);
        Label lblPorConceptoDe = new Label(this.container_1, 0);
        lblPorConceptoDe.setText("Por Concepto de IVA");
        this.txtRetenidoIva = new Text(this.container_1, 2048);
        this.txtRetenidoIva.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                PaginaComprobanteVenta.this.txtRetenidoIva.selectAll();
            }
        });
        this.txtRetenidoIva.setTextLimit(15);
        GridData gd_txtRetenidoIva = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_txtRetenidoIva.widthHint = 100;
        this.txtRetenidoIva.setLayoutData((Object)gd_txtRetenidoIva);
        Label lblProConceptoDe = new Label(this.container_1, 0);
        lblProConceptoDe.setText("Por Concepto de Renta");
        this.txtRetenidoRenta = new Text(this.container_1, 2048);
        this.txtRetenidoRenta.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                PaginaComprobanteVenta.this.txtRetenidoRenta.selectAll();
            }
        });
        this.txtRetenidoRenta.setTextLimit(15);
        GridData gd_txtRetenidoRenta = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_txtRetenidoRenta.widthHint = 100;
        this.txtRetenidoRenta.setLayoutData((Object)gd_txtRetenidoRenta);
        new Label(this.container_1, 0);
        this.initDataBindings();
        this.procesarModeloDatos();
    }

    private void crearCompositeCompensaciones() {
        this.compositeCompensaciones = new CompensacionComposite(this.container_1, 0, (ModeloValores)this.modeloValores, (ObjetoModelo)this.modeloDatos, this);
        this.compositeCompensaciones.setFuncionSeleccionar(new OperacionCompositeCompensaciones(){

            @Override
            public void operar(Compensacion compensacion) {
                if (!PaginaComprobanteVenta.this.modeloDatos.getCompensaciones().contains(compensacion)) {
                    BigDecimal porcentajeCompensacion = PaginaComprobanteVenta.this.modeloValores.obtenerPorcentajeCompensacion(compensacion.getCodigo());
                    compensacion.setPorcentajeCompensacion(porcentajeCompensacion);
                    compensacion.setMonto("0.00");
                    PaginaComprobanteVenta.this.modeloDatos.agregarCompensacion(compensacion);
                }
            }
        });
        this.compositeCompensaciones.setFuncionEliminar(new OperacionCompositeCompensaciones(){

            @Override
            public void operar(Compensacion compensacion) {
                PaginaComprobanteVenta.this.modeloDatos.eliminarCompensaciones(compensacion);
            }
        });
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ISWTObservableValue observeTextTxtNumComprobantesObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtNumComprobantes);
        IObservableValue numeroEmitidosModeloDatosObserveValue = BeanProperties.value((String)"numeroEmitidos").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtNumComprobantesObserveWidget, numeroEmitidosModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtIvaCeroObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtIvaCero);
        IObservableValue baseIvaCeroModeloDatosObserveValue = BeanProperties.value((String)"baseIvaCero").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtIvaCeroObserveWidget, baseIvaCeroModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtIvaNoCeroObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtIvaNoCero);
        IObservableValue baseIvaNoCeroModeloDatosObserveValue = BeanProperties.value((String)"baseIvaNoCero").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtIvaNoCeroObserveWidget, baseIvaNoCeroModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtMontoIvaObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtMontoIva);
        IObservableValue montoIvaModeloDatosObserveValue = BeanProperties.value((String)"montoIva").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtMontoIvaObserveWidget, montoIvaModeloDatosObserveValue, null, null);
        ISWTObservableValue txtMontoIceObserveTextObserveWidget = SWTObservables.observeText((Control)this.txtMontoIce, (int)24);
        IObservableValue modeloDatosMontoIceObserveValue = BeansObservables.observeValue((Object)this.modeloDatos, (String)"montoIce");
        bindingContext.bindValue((IObservableValue)txtMontoIceObserveTextObserveWidget, modeloDatosMontoIceObserveValue, null, null);
        ISWTObservableValue observeTextTxtNoIvaObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtNoIva);
        IObservableValue baseNoIvaModeloDatosObserveValue = BeanProperties.value((String)"baseNoIva").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtNoIvaObserveWidget, baseNoIvaModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtRetenidoIvaObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtRetenidoIva);
        IObservableValue ivaRetenidoModeloDatosObserveValue = BeanProperties.value((String)"ivaRetenido").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtRetenidoIvaObserveWidget, ivaRetenidoModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtRetenidoRentaObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtRetenidoRenta);
        IObservableValue irRetenidoModeloDatosObserveValue = BeanProperties.value((String)"irRetenido").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtRetenidoRentaObserveWidget, irRetenidoModeloDatosObserveValue, null, null);
        ObservableListContentProvider listContentProvider = new ObservableListContentProvider();
        IObservableMap observeMap = PojoObservables.observeMap((IObservableSet)listContentProvider.getKnownElements(), ElementoNombreValor.class, (String)"etiqueta");
        this.cvTipoComprobante.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMap));
        this.cvTipoComprobante.setContentProvider((IContentProvider)listContentProvider);
        IObservableList tiposDeComprobantesModeloValoresObserveList = PojoProperties.list((String)"tiposDeComprobantes").observe((Object)this.modeloValores);
        this.cvTipoComprobante.setInput((Object)tiposDeComprobantesModeloValoresObserveList);
        ISWTObservableValue lblMontoIceObserveVisibleObserveWidget = SWTObservables.observeVisible((Control)this.lblMontoIce);
        IObservableValue periodoPeriodoDeAnexoDesdeMarzo2015ObserveValue = PojoObservables.observeValue((Object)this.periodo, (String)"periodoDeAnexoDesdeMarzo2015");
        bindingContext.bindValue((IObservableValue)lblMontoIceObserveVisibleObserveWidget, periodoPeriodoDeAnexoDesdeMarzo2015ObserveValue, null, null);
        ISWTObservableValue txtMontoIceObserveVisibleObserveWidget = SWTObservables.observeVisible((Control)this.txtMontoIce);
        bindingContext.bindValue((IObservableValue)txtMontoIceObserveVisibleObserveWidget, periodoPeriodoDeAnexoDesdeMarzo2015ObserveValue, null, null);
        ISWTObservableValue compositeCompensacionesObserveVisibleObserveWidget = SWTObservables.observeVisible((Control)this.compositeCompensaciones);
        IObservableValue periodoAnexoEnPeriodoDesdeMayo2016ObserveValue = PojoObservables.observeValue((Object)this.periodo, (String)"anexoEnPeriodoDesdeMayo2016");
        bindingContext.bindValue((IObservableValue)compositeCompensacionesObserveVisibleObserveWidget, periodoAnexoEnPeriodoDesdeMayo2016ObserveValue, null, null);
        ISWTObservableValue btnSonComprobantesElectronicosObserveVisibleObserveWidget_1 = SWTObservables.observeVisible((Control)this.btnSonComprobantesElectronicos);
        IObservableValue periodoAnexoEnPeriodoDesdeEnero2016ObserveValue = PojoObservables.observeValue((Object)this.periodo, (String)"anexoEnPeriodoDesdeEnero2016");
        bindingContext.bindValue((IObservableValue)btnSonComprobantesElectronicosObserveVisibleObserveWidget_1, periodoAnexoEnPeriodoDesdeEnero2016ObserveValue, null, null);
        ISWTObservableValue lblSonComprobantesElectrnicosObserveVisibleObserveWidget_1 = SWTObservables.observeVisible((Control)this.lblSonComprobantesElectrnicos);
        bindingContext.bindValue((IObservableValue)lblSonComprobantesElectrnicosObserveVisibleObserveWidget_1, periodoAnexoEnPeriodoDesdeEnero2016ObserveValue, null, null);
        return bindingContext;
    }
}

